IF OBJECT_ID('sp_cupomfiscal_valida_recebimento') IS NOT NULL
BEGIN
	DROP PROCEDURE [sp_cupomfiscal_valida_recebimento]
END
GO
CREATE PROCEDURE [dbo].[sp_cupomfiscal_valida_recebimento] (@CD_EMP INT, @CD_FILIAL INT, @CD_VD INT) as 
SELECT
				PDV_VD.CD_FILIAL,
				PDV_VD.CD_VD,
				PDV_VD.NR_ECF,
				PDV_VD.CD_CX,
				PDV_VD.DT_VD,
				PDV_VD.ST_VD,
				PDV_VD.VLR_LIQ_VD,
				PDV_VD.VLR_TOT_REC AS VLR_RECEBIMENTO,      
				PDV_VD.VLR_DINH,
				PDV_VD.VLR_CHQS,
				PDV_VD.VLR_CARTAO,
				PDV_VD.VLR_CONV,
				PDV_VD.VLR_DUP,
				PDV_VD.VLR_NCC,
				PDV_VD.VLR_TICKETS,
				PDV_VD.VLR_CONV_PBM,     
CASE	WHEN	(PDV_VD.ST_VD = 0)
		THEN	PDV_VD.VLR_DIF_LANC
ELSE			0
		END AS	VLR_DIFERENCA,      
				PDV_VD.VS_CONSOLIDADOR     
FROM V_PDV_CONFERE_VD AS PDV_VD
WHERE
				PDV_VD.CD_EMP = @CD_EMP
				AND PDV_VD.CD_FILIAL = @CD_FILIAL
				AND PDV_VD.CD_VD = @CD_VD
GO
